/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.blocks.air_blower;

import com.lgmrszd.compressedcreativity.blocks.air_blower.AirBlowerBlock;
import com.lgmrszd.compressedcreativity.config.CommonConfig;
import com.lgmrszd.compressedcreativity.config.PressureTierConfig;
import com.lgmrszd.compressedcreativity.network.IObserveTileEntity;
import com.lgmrszd.compressedcreativity.network.ObservePacket;
import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.content.contraptions.components.fan.IAirCurrentSource;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AirBlowerTileEntity
extends SmartTileEntity
implements IHaveHoveringInformation,
IHaveGoggleInformation,
IObserveTileEntity,
IAirCurrentSource {
    private static final Logger logger = LogManager.getLogger((String)"compressedcreativity");
    public AirCurrent airCurrent;
    protected int entitySearchCooldown;
    protected int airCurrentUpdateCooldown;
    protected boolean updateAirFlow = true;
    protected final IAirHandlerMachine airHandler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler(((PressureTierConfig.PressureTierEnum)((Object)CommonConfig.AIR_BLOWER_PRESSURE_TIER.get())).getPressureTierDefinedOrCustom(PressureTierConfig.CustomTier.AIR_BLOWER_CUSTOM_TIER), ((Integer)CommonConfig.AIR_BLOWER_VOLUME.get()).intValue());
    private final LazyOptional<IAirHandlerMachine> airHandlerCap = LazyOptional.of(() -> this.airHandler);
    private float airBuffer;
    private float airUsage = 0.0f;

    public AirBlowerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.airCurrent = new AirCurrent((IAirCurrentSource)this);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if ((double)this.airHandler.getPressure() <= (Double)CommonConfig.AIR_BLOWER_WORK_PRESSURE.get()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.not_enough_pressure").m_130940_(ChatFormatting.GOLD)));
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.not_enough_pressure_2").m_130940_(ChatFormatting.GRAY)));
            return true;
        }
        return false;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ObservePacket.send(this.f_58858_, 0);
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.pressure_summary")));
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.pressure").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + this.airHandler.getPressure()).m_7220_((Component)new TranslatableComponent("compressedcreativity.unit.bar")).m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.air").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + this.airHandler.getAir()).m_7220_((Component)new TranslatableComponent("compressedcreativity.unit.air")).m_130940_(ChatFormatting.AQUA)));
        if ((double)this.airHandler.getPressure() <= (Double)CommonConfig.AIR_BLOWER_WORK_PRESSURE.get()) {
            return true;
        }
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("compressedcreativity.tooltip.air_usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TextComponent(" " + this.airUsage).m_7220_((Component)new TranslatableComponent("compressedcreativity.unit.air_per_tick")).m_130940_(ChatFormatting.AQUA)));
        return true;
    }

    private float calculateAirUsage(float pressure) {
        return (float)Math.floor(pressure * ((Double)CommonConfig.AIR_BLOWER_AIR_USAGE_PER_BAR.get()).floatValue() * 100.0f) / 100.0f;
    }

    public void updateAirHandler() {
        ArrayList<Direction> sides = new ArrayList<Direction>();
        for (Direction side : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN}) {
            if (!this.canConnectPneumatic(side)) continue;
            sides.add(side);
        }
        this.airHandler.setConnectedFaces(sides);
        logger.debug("Updated Air Handler! Side: " + this.m_58900_().m_61143_(AirBlowerBlock.FACING));
    }

    public void tick() {
        super.tick();
        this.airHandler.tick((BlockEntity)this);
        boolean server = !this.f_58857_.f_46443_ || this.isVirtual();
        this.airUsage = this.calculateAirUsage(this.airHandler.getPressure());
        if (server) {
            if (this.airCurrentUpdateCooldown-- <= 0) {
                this.airCurrentUpdateCooldown = (Integer)AllConfigs.SERVER.kinetics.fanBlockCheckRate.get();
                this.updateAirFlow = true;
            }
            if ((double)this.airHandler.getPressure() > (Double)CommonConfig.AIR_BLOWER_WORK_PRESSURE.get()) {
                this.airBuffer += this.airUsage;
                if (this.airBuffer > 1.0f) {
                    int toRemove = Math.min((int)this.airBuffer, this.airHandler.getAir());
                    this.airHandler.addAir(-toRemove);
                    this.airBuffer -= (float)toRemove;
                }
            }
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            this.sendData();
        }
        if (this.airHandler.getPressure() <= 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        if ((double)this.airHandler.getPressure() > (Double)CommonConfig.AIR_BLOWER_WORK_PRESSURE.get()) {
            this.airCurrent.tick();
            if ((double)this.airHandler.getPressure() > (Double)CommonConfig.AIR_BLOWER_OVERWORK_PRESSURE.get()) {
                this.airCurrent.tick();
            }
        }
    }

    public void initialize() {
        super.initialize();
        this.updateAirHandler();
    }

    public void m_7651_() {
        super.m_7651_();
        this.airHandlerCap.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY && this.canConnectPneumatic(side)) {
            return this.airHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
        return dir != orientation;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("AirHandler", this.airHandler.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.airHandler.deserializeNBT(compound.m_128469_("AirHandler"));
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    @Override
    public void onObserved(ServerPlayer var1, ObservePacket var2) {
    }

    @Nullable
    public AirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    @Nullable
    public Level getAirCurrentWorld() {
        return this.f_58857_;
    }

    public BlockPos getAirCurrentPos() {
        return this.f_58858_;
    }

    public float getSpeed() {
        float speed_ratio = 256.0f / this.calculateAirUsage(this.airHandler.getDangerPressure());
        return (double)this.airHandler.getPressure() > (Double)CommonConfig.AIR_BLOWER_WORK_PRESSURE.get() ? (float)(Math.ceil(this.airUsage * speed_ratio / 8.0f) * 8.0) : 0.0f;
    }

    public Direction getAirflowOriginSide() {
        return (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
    }

    @Nullable
    public Direction getAirFlowDirection() {
        return (Direction)this.m_58900_().m_61143_(AirBlowerBlock.FACING);
    }

    public boolean isSourceRemoved() {
        return this.f_58859_;
    }
}

